/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.objmgr.cec;

import com.ibm.hsc.common.exceptions.PIHscServerException;
import com.ibm.hsc.lock.Lock;
import com.ibm.hsc.objmgr.cec.OmCecLongRunningTask;
import com.ibm.hsc.objmgr.cec.OmCecMgr;

public class OmPendingThreadHandler
extends Thread {
    private OmCecMgr mCecMgr;
    private OmCecLongRunningTask mLongRunningTask;
    private Object mRtnValue = null;
    private boolean mForceStopped = false;
    private Throwable mException = null;
    private Object[] mInParams;
    private Lock mLock;

    OmPendingThreadHandler(OmCecMgr omCecMgr, OmCecLongRunningTask omCecLongRunningTask, Object[] objectArray, Lock lock) {
        this.mCecMgr = omCecMgr;
        this.mLongRunningTask = omCecLongRunningTask;
        this.mInParams = objectArray;
        this.mLock = lock;
    }

    synchronized Object startLongRunningTask() throws PIHscServerException {
        this.mLock.setPending();
        System.out.println("reg long running thread " + this.getName());
        this.mCecMgr.regLongRunningThread(this);
        this.start();
        System.out.println("started long running thread " + this.getName());
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {
            System.out.println("pending thread be interrupted");
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        System.out.println("dereg long running thread " + this.getName());
        this.mCecMgr.deregLongRunningThread(this);
        this.mLock.unsetPending();
        if (this.mForceStopped) {
            throw new PIHscServerException("0267", null);
        }
        if (this.mException != null) {
            if (this.mException instanceof PIHscServerException) {
                throw (PIHscServerException)this.mException;
            }
            throw new PIHscServerException("0268", this.mException);
        }
        return this.mRtnValue;
    }

    void forceStop() {
        this.mForceStopped = true;
        System.out.println("before interrupt " + this.getName());
        this.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.mRtnValue = this.mLongRunningTask.performLongRunningTask(this.mInParams);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            this.mException = throwable;
        }
        OmPendingThreadHandler omPendingThreadHandler = this;
        synchronized (omPendingThreadHandler) {
            if (!this.mForceStopped) {
                this.notify();
            }
        }
    }
}

